!function(mod){"object"==typeof exports&&"object"==typeof module?mod(require("../../lib/codemirror")):"function"==typeof define&&define.amd?define(["../../lib/codemirror"],mod):mod(CodeMirror)}(function(CodeMirror){"use strict";function Completion(cm,options){this.cm=cm,this.options=options,this.widget=null,this.debounce=0,this.tick=0,this.startPos=this.cm.getCursor("start"),this.startLen=this.cm.getLine(this.startPos.line).length-this.cm.getSelection().length;var self=this;cm.on("cursorActivity",this.activityFunc=function(){self.cursorActivity()})}function isNewCompletion(old,nw){return CodeMirror.cmpPos(nw.from,old.from)>0&&old.to.ch-old.from.ch!=nw.to.ch-nw.from.ch}function parseOptions(cm,pos,options){var editor=cm.options.hintOptions,out={};for(var prop in defaultOptions)out[prop]=defaultOptions[prop];if(editor)for(var prop in editor)void 0!==editor[prop]&&(out[prop]=editor[prop]);if(options)for(var prop in options)void 0!==options[prop]&&(out[prop]=options[prop]);return out.hint.resolve&&(out.hint=out.hint.resolve(cm,pos)),out}function getText(completion){return"string"==typeof completion?completion:completion.text}function buildKeyMap(completion,handle){function addBinding(key,val){var bound;bound="string"!=typeof val?function(cm){return val(cm,handle)}:baseMap.hasOwnProperty(val)?baseMap[val]:val,ourMap[key]=bound}var baseMap={Up:function(){handle.moveFocus(-1)},Down:function(){handle.moveFocus(1)},PageUp:function(){handle.moveFocus(1-handle.menuSize(),!0)},PageDown:function(){handle.moveFocus(handle.menuSize()-1,!0)},Home:function(){handle.setFocus(0)},End:function(){handle.setFocus(handle.length-1)},Enter:handle.pick,Tab:handle.pick,Esc:handle.close},custom=completion.options.customKeys,ourMap=custom?{}:baseMap;if(custom)for(var key in custom)custom.hasOwnProperty(key)&&addBinding(key,custom[key]);var extra=completion.options.extraKeys;if(extra)for(var key in extra)extra.hasOwnProperty(key)&&addBinding(key,extra[key]);return ourMap}function getHintElement(hintsElement,el){for(;el&&el!=hintsElement;){if("LI"===el.nodeName.toUpperCase()&&el.parentNode==hintsElement)return el;el=el.parentNode}}function Widget(completion,data){this.completion=completion,this.data=data,this.picked=!1;var widget=this,cm=completion.cm,hints=this.hints=document.createElement("ul");hints.className="CodeMirror-hints",this.selectedHint=data.selectedHint||0;for(var completions=data.list,i=0;i<completions.length;++i){var elt=hints.appendChild(document.createElement("li")),cur=completions[i],className=HINT_ELEMENT_CLASS+(i!=this.selectedHint?"":" "+ACTIVE_HINT_ELEMENT_CLASS);null!=cur.className&&(className=cur.className+" "+className),elt.className=className,cur.render?cur.render(elt,data,cur):elt.appendChild(document.createTextNode(cur.displayText||getText(cur))),elt.hintId=i}var pos=cm.cursorCoords(completion.options.alignWithWord?data.from:null),left=pos.left,top=pos.bottom,below=!0;hints.style.left=left+"px",hints.style.top=top+"px";var winW=window.innerWidth||Math.max(document.body.offsetWidth,document.documentElement.offsetWidth),winH=window.innerHeight||Math.max(document.body.offsetHeight,document.documentElement.offsetHeight);(completion.options.container||document.body).appendChild(hints);var box=hints.getBoundingClientRect(),overlapY=box.bottom-winH,scrolls=hints.scrollHeight>hints.clientHeight+1,startScroll=cm.getScrollInfo();if(overlapY>0){var height=box.bottom-box.top;if(pos.top-(pos.bottom-box.top)-height>0)hints.style.top=(top=pos.top-height)+"px",below=!1;else if(height>winH){hints.style.height=winH-5+"px",hints.style.top=(top=pos.bottom-box.top)+"px";var cursor=cm.getCursor();data.from.ch!=cursor.ch&&(pos=cm.cursorCoords(cursor),hints.style.left=(left=pos.left)+"px",box=hints.getBoundingClientRect())}}var overlapX=box.right-winW;if(overlapX>0&&(box.right-box.left>winW&&(hints.style.width=winW-5+"px",overlapX-=box.right-box.left-winW),hints.style.left=(left=pos.left-overlapX)+"px"),scrolls)for(var node=hints.firstChild;node;node=node.nextSibling)node.style.paddingRight=cm.display.nativeBarWidth+"px";if(cm.addKeyMap(this.keyMap=buildKeyMap(completion,{moveFocus:function(n,avoidWrap){widget.changeActive(widget.selectedHint+n,avoidWrap)},setFocus:function(n){widget.changeActive(n)},menuSize:function(){return widget.screenAmount()},length:completions.length,close:function(){completion.close()},pick:function(){widget.pick()},data:data})),completion.options.closeOnUnfocus){var closingOnBlur;cm.on("blur",this.onBlur=function(){closingOnBlur=setTimeout(function(){completion.close()},100)}),cm.on("focus",this.onFocus=function(){clearTimeout(closingOnBlur)})}return cm.on("scroll",this.onScroll=function(){var curScroll=cm.getScrollInfo(),editor=cm.getWrapperElement().getBoundingClientRect(),newTop=top+startScroll.top-curScroll.top,point=newTop-(window.pageYOffset||(document.documentElement||document.body).scrollTop);if(below||(point+=hints.offsetHeight),point<=editor.top||point>=editor.bottom)return completion.close();hints.style.top=newTop+"px",hints.style.left=left+startScroll.left-curScroll.left+"px"}),CodeMirror.on(hints,"dblclick",function(e){var t=getHintElement(hints,e.target||e.srcElement);t&&null!=t.hintId&&(widget.changeActive(t.hintId),widget.pick())}),CodeMirror.on(hints,"click",function(e){var t=getHintElement(hints,e.target||e.srcElement);t&&null!=t.hintId&&(widget.changeActive(t.hintId),completion.options.completeOnSingleClick&&widget.pick())}),CodeMirror.on(hints,"mousedown",function(){setTimeout(function(){cm.focus()},20)}),CodeMirror.signal(data,"select",completions[0],hints.firstChild),!0}function applicableHelpers(cm,helpers){if(!cm.somethingSelected())return helpers;for(var result=[],i=0;i<helpers.length;i++)helpers[i].supportsSelection&&result.push(helpers[i]);return result}function fetchHints(hint,cm,options,callback){if(hint.async)hint(cm,callback,options);else{var result=hint(cm,options);result&&result.then?result.then(callback):callback(result)}}function resolveAutoHints(cm,pos){var words,helpers=cm.getHelpers(pos,"hint");if(helpers.length){var resolved=function(cm,callback,options){function run(i){if(i==app.length)return callback(null);fetchHints(app[i],cm,options,function(result){result&&result.list.length>0?callback(result):run(i+1)})}var app=applicableHelpers(cm,helpers);run(0)};return resolved.async=!0,resolved.supportsSelection=!0,resolved}return(words=cm.getHelper(cm.getCursor(),"hintWords"))?function(cm){return CodeMirror.hint.fromList(cm,{words:words})}:CodeMirror.hint.anyword?function(cm,options){return CodeMirror.hint.anyword(cm,options)}:function(){}}var HINT_ELEMENT_CLASS="CodeMirror-hint",ACTIVE_HINT_ELEMENT_CLASS="CodeMirror-hint-active";CodeMirror.showHint=function(cm,getHints,options){if(!getHints)return cm.showHint(options);options&&options.async&&(getHints.async=!0);var newOpts={hint:getHints};if(options)for(var prop in options)newOpts[prop]=options[prop];return cm.showHint(newOpts)},CodeMirror.defineExtension("showHint",function(options){options=parseOptions(this,this.getCursor("start"),options);var selections=this.listSelections();if(!(selections.length>1)){if(this.somethingSelected()){if(!options.hint.supportsSelection)return;for(var i=0;i<selections.length;i++)if(selections[i].head.line!=selections[i].anchor.line)return}this.state.completionActive&&this.state.completionActive.close();var completion=this.state.completionActive=new Completion(this,options);completion.options.hint&&(CodeMirror.signal(this,"startCompletion",this),completion.update(!0))}});var requestAnimationFrame=window.requestAnimationFrame||function(fn){return setTimeout(fn,1e3/60)},cancelAnimationFrame=window.cancelAnimationFrame||clearTimeout;Completion.prototype={close:function(){this.active()&&(this.cm.state.completionActive=null,this.tick=null,this.cm.off("cursorActivity",this.activityFunc),this.widget&&this.data&&CodeMirror.signal(this.data,"close"),this.widget&&this.widget.close(),CodeMirror.signal(this.cm,"endCompletion",this.cm))},active:function(){return this.cm.state.completionActive==this},pick:function(data,i){var completion=data.list[i];completion.hint?completion.hint(this.cm,data,completion):this.cm.replaceRange(getText(completion),completion.from||data.from,completion.to||data.to,"complete"),CodeMirror.signal(data,"pick",completion),this.close()},cursorActivity:function(){this.debounce&&(cancelAnimationFrame(this.debounce),this.debounce=0);var pos=this.cm.getCursor(),line=this.cm.getLine(pos.line);if(pos.line!=this.startPos.line||line.length-pos.ch!=this.startLen-this.startPos.ch||pos.ch<this.startPos.ch||this.cm.somethingSelected()||pos.ch&&this.options.closeCharacters.test(line.charAt(pos.ch-1)))this.close();else{var self=this;this.debounce=requestAnimationFrame(function(){self.update()}),this.widget&&this.widget.disable()}},update:function(first){if(null!=this.tick){var self=this,myTick=++this.tick;fetchHints(this.options.hint,this.cm,this.options,function(data){self.tick==myTick&&self.finishUpdate(data,first)})}},finishUpdate:function(data,first){this.data&&CodeMirror.signal(this.data,"update");var picked=this.widget&&this.widget.picked||first&&this.options.completeSingle;this.widget&&this.widget.close(),data&&this.data&&isNewCompletion(this.data,data)||(this.data=data,data&&data.list.length&&(picked&&1==data.list.length?this.pick(data,0):(this.widget=new Widget(this,data),CodeMirror.signal(data,"shown"))))}},Widget.prototype={close:function(){if(this.completion.widget==this){this.completion.widget=null,this.hints.parentNode.removeChild(this.hints),this.completion.cm.removeKeyMap(this.keyMap);var cm=this.completion.cm;this.completion.options.closeOnUnfocus&&(cm.off("blur",this.onBlur),cm.off("focus",this.onFocus)),cm.off("scroll",this.onScroll)}},disable:function(){this.completion.cm.removeKeyMap(this.keyMap);var widget=this;this.keyMap={Enter:function(){widget.picked=!0}},this.completion.cm.addKeyMap(this.keyMap)},pick:function(){this.completion.pick(this.data,this.selectedHint)},changeActive:function(i,avoidWrap){if(i>=this.data.list.length?i=avoidWrap?this.data.list.length-1:0:i<0&&(i=avoidWrap?0:this.data.list.length-1),this.selectedHint!=i){var node=this.hints.childNodes[this.selectedHint];node.className=node.className.replace(" "+ACTIVE_HINT_ELEMENT_CLASS,""),node=this.hints.childNodes[this.selectedHint=i],node.className+=" "+ACTIVE_HINT_ELEMENT_CLASS,node.offsetTop<this.hints.scrollTop?this.hints.scrollTop=node.offsetTop-3:node.offsetTop+node.offsetHeight>this.hints.scrollTop+this.hints.clientHeight&&(this.hints.scrollTop=node.offsetTop+node.offsetHeight-this.hints.clientHeight+3),CodeMirror.signal(this.data,"select",this.data.list[this.selectedHint],node)}},screenAmount:function(){return Math.floor(this.hints.clientHeight/this.hints.firstChild.offsetHeight)||1}},CodeMirror.registerHelper("hint","auto",{resolve:resolveAutoHints}),CodeMirror.registerHelper("hint","fromList",function(cm,options){var cur=cm.getCursor(),token=cm.getTokenAt(cur),to=CodeMirror.Pos(cur.line,token.end);if(token.string&&/\w/.test(token.string[token.string.length-1]))var term=token.string,from=CodeMirror.Pos(cur.line,token.start);else var term="",from=to;for(var found=[],i=0;i<options.words.length;i++){var word=options.words[i];word.slice(0,term.length)==term&&found.push(word)}if(found.length)return{list:found,from:from,to:to}}),CodeMirror.commands.autocomplete=CodeMirror.showHint;var defaultOptions={hint:CodeMirror.hint.auto,completeSingle:!0,alignWithWord:!0,closeCharacters:/[\s()\[\]{};:>,]/,closeOnUnfocus:!0,completeOnSingleClick:!0,container:null,customKeys:null,extraKeys:null};CodeMirror.defineOption("hintOptions",null)});